﻿using System;
using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.PersonSearch
{
    /// <summary>
    /// Map Person Search to Attended Search step.
    /// </summary>
    public class MapPersonSearchToAttendedSearchStep : FilterBase<PersonSearchStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(PersonSearchStateObject state)
        {
            state.AttendedSearchRequest = new PersonSearchMapper(state).Map();
            state.SerializedInstance = string.Format("PersonSearch Response {0},{1}", Environment.NewLine, PipelineUtilities.SerializeInstance(state.PersonSearchResponseMessage));
        }
    }
}